// $Id: CApplication.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CApplication.hpp"
using Exponent::Host::CApplication;

#ifdef WIN32
//	===========================================================================
HINSTANCE CApplication::CAPPLICATION_INSTANCEHANDLE = NULL;

//	===========================================================================
HMODULE CApplication::CAPPLICATION_MODULEHANDLE = NULL;

//	===========================================================================
HWND CApplication::CAPPLICATION_WINDOWHANDLE = NULL;
#else
#include "../Exceptions/CException.hpp"
using Exponent::Exceptions::CException;

//	===========================================================================
CString CApplication::CAPPLICATION_INSTANCEHANDLE = "com.exponent.foo";

//	===========================================================================
CString CApplication::CAPPLICATION_MODULEHANDLE = "com.exponent.foo";
#endif

//	===========================================================================
CString CApplication::CAPPLICATION_NAME("New Application");

//	===========================================================================
CString CApplication::CAPPLICATION_DEVELOPER("Exponent");

//	===========================================================================
CString CApplication::CAPPLICATION_VERSION("1.0.0");

//	===========================================================================
CString CApplication::CAPPLICATION_COPYRIGHT("Created using Exponent API Technology");

//	===========================================================================
CString CApplication::CAPPLICATION_PRODUCT("Product description");

//	===========================================================================
CSystemString CApplication::CAPPLICATION_INSTALL_PATH("");

//	===========================================================================
IWindow *CApplication::CAPPLICATION_WINDOW = NULL;

//	===========================================================================
CString CApplication::CAPPLICATION_REGISTRY("");

//	===========================================================================
#ifdef WIN32
void CApplication::getCurrentExecutableFileName(CString &filename)
{
	char name[1024];
	memset(name, 0, 1024 * sizeof(char));
	GetModuleFileName(0, name, 1024);
	filename = name;
}

//	===========================================================================
void CApplication::getModuleFileName(CString &filename)
{
	char name[1024];
	memset(name, 0, 1024);
	GetModuleFileName(CAPPLICATION_MODULEHANDLE, name, 1024);
	filename = name;
}
#endif

//	===========================================================================
unsigned long CApplication::runApplicationEventLoop()
{
#ifdef WIN32
	MSG message;
	while(GetMessage(&message, NULL, 0, 0))
	{
		TranslateMessage(&message);
		DispatchMessage(&message);
	}
	return (unsigned long)message.wParam;
#else
	RunApplicationEventLoop();
	return 0;
#endif
}

//	===========================================================================
void CApplication::stopApplicationEventLoop()
{
#ifdef WIN32
	PostQuitMessage(0);
#else
	QuitApplicationEventLoop();
#endif
}

//	===========================================================================
void CApplication::setApplicationName(const CString &applicationName)
{
	CAPPLICATION_NAME = applicationName;
}

//	===========================================================================
void CApplication::setApplicationDeveloper(const CString &applicationDeveloper)
{
	CAPPLICATION_DEVELOPER = applicationDeveloper;
}

//	===========================================================================
void CApplication::setApplicationVersion(const CString &applicationVersion)
{
	CAPPLICATION_VERSION = applicationVersion;
}

//	===========================================================================
void CApplication::setApplicationCopyrightInformation(const CString &applicationCopyRight)
{
	CAPPLICATION_COPYRIGHT = applicationCopyRight;
}

//	===========================================================================
void CApplication::setApplicationDescription(const CString &applicationDescription)
{
	CAPPLICATION_PRODUCT = applicationDescription;
}

//	===========================================================================
void CApplication::setApplicationInstallPath(const CSystemString &path)
{
	CAPPLICATION_INSTALL_PATH = path;
}

//	===========================================================================
void CApplication::setApplicationRegistry(const CString &path)
{
	CAPPLICATION_REGISTRY = path;
}

//	===========================================================================
void CApplication::setApplicationInstallPathFromApplicationHandle()
{
#ifdef WIN32
	// GEt the name
	CSystemString filename;
	getModuleFileName(filename);

	// Remove the dll name
	filename.removeLastPathComponent();

	// Store it
	setApplicationInstallPath(filename);
#else
	// Get the bundle
	CFBundleRef thisBundle = CFBundleGetBundleWithIdentifier(CFStringCreateWithCString(kCFAllocatorDefault, CAPPLICATION_MODULEHANDLE.getString(), kCFStringEncodingMacRoman));

	// Check its valid
	if (thisBundle == 0)
	{
		throw CException("Failed to get bundle from identifier", "CApplication::setApplicationInstallPathFromApplicationHandle()");
	}
	else
	{
		// Get the url ref
		CFURLRef bundleURL = CFBundleCopyBundleURL(thisBundle);

		// Check its valid
		if (bundleURL == 0)
		{
			throw CException("Failed to get bundle URL from bundle", "CApplication::setApplicationInstallPathFromApplicationHandle()");
		}
		else
		{
			// Create a buffer to store the ref in
			UInt8 buffer[_MAX_PATH];
			memset(buffer, 0, _MAX_PATH * sizeof(char));

			// Get the actual url
			CFURLGetFileSystemRepresentation(bundleURL, TRUE, buffer, _MAX_PATH);

			// Store the new path
			CSystemString filename = (const char *)buffer;
			
			// remove the bundle part
			filename.removeLastPathComponent();

			// Store it
			setApplicationInstallPath(filename);
		}
	}
#endif
}

//	===========================================================================
void CApplication::setApplicationWindow(IWindow *window)
{
	CAPPLICATION_WINDOW = window;
}

//	===========================================================================
const CString &CApplication::getApplicationName()
{
	return CAPPLICATION_NAME;
}

//	===========================================================================
const CString &CApplication::getApplicationDeveloper()
{
	return CAPPLICATION_DEVELOPER;
}

//	===========================================================================
const CString &CApplication::getApplicationVersion()
{
	return CAPPLICATION_VERSION;
}

//	===========================================================================
const CString &CApplication::getApplicationCopyrightInformation()
{
	return CAPPLICATION_COPYRIGHT;
}

//	===========================================================================
const CString &CApplication::getApplicationDescription()
{
	return CAPPLICATION_PRODUCT;
}

//	===========================================================================
const CSystemString &CApplication::getApplicationInstallPath()
{
	return CAPPLICATION_INSTALL_PATH;
}

//	===========================================================================
const IWindow *CApplication::getApplicationWindow()
{
	return CAPPLICATION_WINDOW;
}

//	===========================================================================
const CString &CApplication::getApplicationRegistry()
{
	return CAPPLICATION_REGISTRY;
}
